<?php
defined('PF_VERSION') OR exit('Access denied');
function get_widgtes($from_folder) {
    $widgets = array ();
    if (is_dir ( $from_folder )) {
        if ($handle = @opendir ( $from_folder )) {
            while ( $file = readdir ( $handle ) ) {
                if ((is_dir ( $from_folder . '/' . $file )) && ($file != '.') && ($file != '..') && ($file != '.svn')) {
                    if (is_file ( $from_folder . '/' . $file . '/' . $file . '.php' )) {
                        $widgets [$file] = get_widget_info ($file, $from_folder . '/' . $file . '/' . $file . '.php' );
                    }
                }
            }
            closedir ( $handle );
        }
    }
    
    return $widgets;
}
function get_widget_info($plugin_name,$file) {
    require $file;
    $widget_info = array();
    
    $widget_class = ucfirst(strtolower($plugin_name)).'_Widget';
    $widget_object = null;
    if (class_exists($widget_class)){
        $widget_object = new $widget_class(array(),array());
        if (!empty($widget_object->name)){
            $widget_info['name'] = $widget_object->name;
            if (!empty($widget_object->version)){
                $widget_info['version'] = $widget_object->version;
            }
            if (!empty($widget_object->description)){
                $widget_info['description'] = $widget_object->description;
            }
        }
    }
    
    return $widget_info;
}